<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:script="urn:WebWorks-Script-Block"
                              exclude-result-prefixes="xsl msxsl wwmode wwfiles wwdoc wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc script"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />

 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />


 <xsl:template match="/">
  <xsl:variable name="style-lists">
<html>
 <head><title>A List of Styles</title></head>
 <body>

   <!-- Query files to process -->
   <!--                        -->
   <xsl:for-each select="$GlobalInput[1]">
    <xsl:variable name="VarWIFFiles" select="key('wwfiles-files-by-type', 'engine:wif')" />
    <!-- Process files -->
    <!--               -->
    <xsl:variable name="VarProgressFilesStart" select="wwprogress:Start(count($VarWIFFiles))" />

    <xsl:for-each select="$VarWIFFiles">
     <xsl:variable name="VarWIFFile" select="." />
     
     <xsl:variable name="VarProgressFileStart" select="wwprogress:Start(1)" />
     
     <!-- Process single file -->
     <!--                     -->
     <xsl:if test="not(wwprogress:Abort())">
      <xsl:variable name="wif-xml" select="wwexsldoc:LoadXMLWithoutResolver($VarWIFFile/@path)" />
      <xsl:variable name="wif-styles" select="script:GetStyleList($wif-xml)" />
      <xsl:copy-of select="$wif-styles" />
      <xsl:message>
       <xsl:copy-of select="$wif-styles" />
      </xsl:message>
     </xsl:if>
     <xsl:variable name="VarProgressEnd" select="wwprogress:End()" />
    </xsl:for-each>
    <xsl:variable name="VarProgressEnd" select="wwprogress:End()" />
   </xsl:for-each>

 </body>
</html>
  </xsl:variable>

  <xsl:variable name="html-output" select="msxsl:node-set($style-lists)" />

  <wwfiles:Files>

   <xsl:variable name="output-path" 
                 select="wwfilesystem:Combine(
                             wwprojext:GetTargetOutputDirectoryPath(),
                             'style-list.html'
                         )" />
   <xsl:variable name="action-write-output-doc"
                 select="wwexsldoc:Document(
                             $html-output,
                             $output-path,
                             wwprojext:GetFormatSetting('encoding', 'utf-8'), 
                             'xhtml', '1.0', 'yes', 'no', 'no', 
                             '-//W3C//DTD XHTML 1.0 Transitional//EN', 
                             'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'
                         )" />
       
   <wwfiles:File path="$output-path" />
  </wwfiles:Files>

 </xsl:template>    

 <msxsl:script language="C#" implements-prefix="script">
  <msxsl:using namespace="System.Xml" />
  <msxsl:using namespace="System.Xml.XPath" />
  <![CDATA[
    public XPathNodeIterator GetStyleList(object input)
    {
      //should do a lock(this.SyncRoot) when in a real deal extension object
      
      // Iterator or navigator?
      //
      if (input is XPathNodeIterator)
      {
        return this.GetStyleListNodeSet(input as XPathNodeIterator);
      }
      else if (input is XPathNavigator)
      {
        return this.GetStyleListNodeSet(input as XPathNavigator);
      }

      XmlDocument doc = new XmlDocument();
      doc.LoadXml("<?xml version=\"1.0\"?><root />");
      return doc.CreateNavigator().Select("/");
    }

    public XPathNodeIterator GetStyleListNodeSet(XPathNodeIterator iterator)
    {
      iterator.MoveNext();
      return this.GetStyleListNodeSet(iterator.Current);
    }

    public XPathNodeIterator GetStyleListNodeSet(XPathNavigator wifFile)
    {
      string XhtmlNs = "http://www.w3.org/1999/xhtml";
      XmlNamespaceManager nsmgr = new XmlNamespaceManager(wifFile.NameTable);
      nsmgr.AddNamespace("wwdoc", "urn:WebWorks-Document-Schema");

      XmlDocument doc = new XmlDocument();

      // start ul
      XmlNode ul = doc.CreateElement("ul", XhtmlNs);
      XPathExpression selectStyleNames = XPathExpression.Compile("/wwdoc:Document/wwdoc:Styles/wwdoc:ParagraphStyles/wwdoc:ParagraphStyle", nsmgr);
      XPathNodeIterator fileList = wifFile.Select(selectStyleNames);
      while (fileList.MoveNext())
      {
        // start li
        XmlNode curLi = doc.CreateElement("li", XhtmlNs);
        curLi.AppendChild(doc.CreateTextNode(fileList.Current.GetAttribute("name", wifFile.NamespaceURI).ToString()));
        ul.AppendChild(curLi);
      }
      doc.AppendChild(ul);

      return doc.CreateNavigator().Select("/", new XmlNamespaceManager(doc.NameTable));
    }

  ]]>
 </msxsl:script>
</xsl:stylesheet>